(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     29129,        664]
NotebookOptionsPosition[     27974,        622]
NotebookOutlinePosition[     28320,        637]
CellTagsIndexPosition[     28277,        634]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"0.01", "+", 
          RowBox[{"0.01", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"x", "/", "2.5"}], "]"}]}], "+", 
          RowBox[{"RandomReal", "[", 
           RowBox[{"NormalDistribution", "[", 
            RowBox[{"0.", ",", "0.001"}], "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1400", ",", "1401", ",", "0.03"}], "}"}]}], "]"}], 
     ",", 
     RowBox[{"{", "100", "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.536382530431178*^9, 3.536382558714159*^9}, {
  3.536382590257561*^9, 3.536382603673647*^9}, {3.5363839625030346`*^9, 
  3.5363839652643766`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"meanval", " ", "=", " ", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{"Mean", ",", "data"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5363827626851573`*^9, 3.536382775586357*^9}, {
  3.5363828655213575`*^9, 3.536382866285757*^9}, {3.5363839365589046`*^9, 
  3.536383945279752*^9}, {3.53638398250426*^9, 3.536383991318712*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", "meanval", "]"}]], "Input",
 CellChangeTimes->{{3.5363840445340414`*^9, 3.536384052490449*^9}}],

Cell[BoxData["0.00017797367667371226`"], "Output",
 CellChangeTimes->{3.5363840531768847`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data5", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"0.01", "+", 
          RowBox[{"0.01", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"x", "/", "2.5"}], "]"}]}], "+", 
          RowBox[{"RandomReal", "[", 
           RowBox[{"NormalDistribution", "[", 
            RowBox[{"0.", ",", "0.001"}], "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1400", ",", "1405", ",", "0.03"}], "}"}]}], "]"}], 
     ",", 
     RowBox[{"{", "100", "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5363841602325745`*^9, 3.536384165427641*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{
   RowBox[{"Map", "[", 
    RowBox[{"Mean", ",", "data5"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.536384192573033*^9, 3.5363842313090672`*^9}, {
  3.5363844355169945`*^9, 3.5363844373266287`*^9}}],

Cell[BoxData["0.00007606666840596435`"], "Output",
 CellChangeTimes->{{3.536384202775956*^9, 3.5363842319798803`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"sig", " ", "=", " ", 
   RowBox[{"Map", "[", 
    RowBox[{"StandardDeviation", ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{"Mean", ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"1", "+", 
                 RowBox[{"0.01", "*", 
                  RowBox[{"Sin", "[", 
                   RowBox[{"x", "/", "0.5"}], "]"}]}], "+", 
                 RowBox[{"RandomReal", "[", 
                  RowBox[{"NormalDistribution", "[", 
                   RowBox[{"0.", ",", "0.005"}], "]"}], "]"}]}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "f", ",", 
                RowBox[{"f", "+", "i"}], ",", "0.03"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"f", ",", "1400", ",", "1420", ",", "i"}], "}"}]}], 
           "]"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "10"}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.536384287766553*^9, 3.536384384816019*^9}, {
   3.53638459126932*^9, 3.536384604062402*^9}, 3.5363846554335313`*^9, {
   3.536385152091708*^9, 3.536385152450508*^9}, {3.5363864200900297`*^9, 
   3.536386495204993*^9}, {3.5363865650626297`*^9, 3.5363865665602393`*^9}, {
   3.5363878079130936`*^9, 3.5363878356186934`*^9}, {3.5364002590615444`*^9, 
   3.5364003047071447`*^9}, {3.536400362645544*^9, 3.5364003778867445`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"sig", ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Medium"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"sig", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/", 
      RowBox[{"Sqrt", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "20"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.536384619537701*^9, 3.536384626947749*^9}, {
  3.5363848063956995`*^9, 3.536384813680908*^9}, {3.5363848437421083`*^9, 
  3.5363848921489086`*^9}, {3.536384944861308*^9, 3.5363850137821083`*^9}, {
  3.536385047025708*^9, 3.5363851167889085`*^9}, {3.5363851599853086`*^9, 
  3.5363851856629086`*^9}, {3.5363865310386524`*^9, 3.536386543113207*^9}, {
  3.5363865824879413`*^9, 3.536386584001151*^9}, {3.5363878424046936`*^9, 
  3.536387844027094*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7LdtOLSJcV6VPVTAwcfPgkFDKQfK53A4c3T2
yxReRyhfwGHpv6iySVrhUL6IA8cqkzdfWBKgfAkHiZweto2u7lC+jINJjea+
ZzyBUL6CQ/5EvmMXFISgfCUHn9OFhroZJlC+ikOua0egvoqd/WB3HwAbkUg+

    "], {
     {Hue[0.67, 0.6, 0.6], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->Medium], 11], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->Medium], 12], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->Medium], 13], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->Medium], 14], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->Medium], 15], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->Medium], 16], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->Medium], 17], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->Medium], 18], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->Medium], 19], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->Medium], 20]}, {}}], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVjnk41Psex2eYDKJG4sTIkDiKzPC7lnB8viUVx740Yx9rwjBmkSVbEdly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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->{573., Automatic},
  PlotRange->{{0., 10.}, {0., 0.006498343118590258}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5363846274781523`*^9, {3.5363848075345063`*^9, 3.536384814180108*^9}, 
   3.5363848928509083`*^9, 3.5363850153421087`*^9, {3.5363850618769083`*^9, 
   3.5363851172257085`*^9}, {3.536385160968108*^9, 3.5363851861309085`*^9}, {
   3.536386428592139*^9, 3.5363865008054647`*^9}, {3.5363865322398677`*^9, 
   3.5363865435500126`*^9}, 3.5363865847031555`*^9, 3.5363878444014935`*^9, 
   3.5364003826759443`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"1", "+", 
       RowBox[{"0.01", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", "/", "0.5"}], "]"}]}], "+", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0.", ",", "0.005"}], "]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5", ",", "0.03"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5363873067674932`*^9, 3.536387389104294*^9}, {
  3.536387437573494*^9, 3.536387534558694*^9}, {3.536387588331894*^9, 
  3.5363876542218933`*^9}, {3.5363876856870937`*^9, 3.536387777961094*^9}, {
  3.536400527846876*^9, 3.536400578489994*^9}, {3.5364007323035593`*^9, 
  3.536400806953239*^9}, {3.536400844287475*^9, 3.536400852243781*^9}}],

Cell[BoxData[
 GraphicsBox[
  {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw9lQtQU2cWx0kIJCQ88qAIEUEELNBKGaJEdPEc1MpSkGcV1ta2dtU6lkFq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    "]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->Automatic,
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{{3.536387376671094*^9, 3.5363873895878935`*^9}, {
   3.5363874405062933`*^9, 3.5363875351202936`*^9}, {3.536387589049494*^9, 
   3.536387655501094*^9}, {3.536387687293894*^9, 3.5363876977614937`*^9}, {
   3.5363877484770937`*^9, 3.5363877786474934`*^9}, 3.5364005301559277`*^9, 
   3.5364005608132677`*^9, {3.5364007353146877`*^9, 3.5364008081232843`*^9}, 
   3.536400854100252*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5364004586367345`*^9, 3.5364004774211817`*^9}, 
   3.536400513618126*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sig", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"StandardDeviation", "[", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{"Mean", ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"1", "+", 
                 RowBox[{"0.01", "*", 
                  RowBox[{"Sin", "[", 
                   RowBox[{"x", "/", "0.5"}], "]"}]}], "+", 
                 RowBox[{"RandomReal", "[", 
                  RowBox[{"NormalDistribution", "[", 
                   RowBox[{"0.", ",", "0.005"}], "]"}], "]"}]}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "i", ",", 
                RowBox[{"i", "+", "n"}], ",", "0.03"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", "100", ",", 
              RowBox[{"n", "+", "0.03"}]}], "}"}]}], "]"}]}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "20", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5364015622116385`*^9, 3.5364016494059997`*^9}, {
   3.5364017522911577`*^9, 3.536401759641758*^9}, {3.536401809613958*^9, 
   3.5364018833571577`*^9}, {3.5364019171653576`*^9, 3.536401932985758*^9}, {
   3.5364019792251577`*^9, 3.5364019806759577`*^9}, {3.5364020190987577`*^9, 
   3.5364020275383577`*^9}, {3.536402062670558*^9, 3.5364020886289577`*^9}, {
   3.536402120577758*^9, 3.5364022565281577`*^9}, {3.536402288367758*^9, 
   3.5364022967615576`*^9}, 3.536402361477358*^9, 3.5364023990431576`*^9, 
   3.5364024564027576`*^9, {3.536403154576758*^9, 3.5364031611287575`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0.005945910528997227`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0.0005087215158455922`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0.0013550261104868426`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0.0006949472218616147`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "0.0003744264019698404`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "0.000976398427658014`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "0.00018161939877537535`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "0.0004472645312334969`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "0.0003273894486279775`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "0.0002773174839429241`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5364024591337576`*^9, 3.5364024808499575`*^9}, 
   3.536403165309558*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"sig", ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Medium"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5364022676977577`*^9, 3.536402272455758*^9}, {
  3.5364023104905577`*^9, 3.5364023152953577`*^9}, {3.5364025013493576`*^9, 
  3.536402501458558*^9}, {3.5364031909463577`*^9, 3.536403222837758*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7DU+W+y8H55hD+FzODTm/FEqX+0A5Ys4RD6X
Mk0xDoPyZRw4AyecXnzUDcpXcjgRsE3taqcFlK/moLnObcX8f/5QvpaDGOPE
g0rn1KF8PYey4hMdt/xtoXxDh3v3J/9cV2IK5Rs7XPbSa5urY2R/XVJkztID
DA6o7vtgbzHJ1WRvVMWgcy8AgnFZ0w==
   "], {
    {Hue[0.67, 0.6, 0.6], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->Medium], 12], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->Medium], 13], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->Medium], 14], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->Medium], 15], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->Medium], 16], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->Medium], 17], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->Medium], 18], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->Medium], 19], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->Medium], 20], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->Medium], 21]}, {}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 19.}, {0., 0.0029715890503027205`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.536402273110958*^9, {3.536402311738558*^9, 3.536402316293758*^9}, 
   3.536402386905358*^9, 3.5364024381759577`*^9, 3.5364024883535576`*^9, {
   3.5364031704263577`*^9, 3.536403192506358*^9}, 3.5364032240585575`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztW8trE0EYn3STWotGaCu0CNqLUlTwHig92VZsWvReJW0NCaLVtufiwV4U
YT36B+hJEBVy6q09R0Q9LRT6D1QRPK87r33O49tHko2mNJPtPH7fY775vvlm
ttXaTuPBo9pOc702vbBVe9Jorm9Pz29uOVVGAaFCAyF0NI3ws+08ssJ2fu0m
LnCN+Pkp+Soiy6wg/lNv2SukegS16qyuYiKLArp1FdNaIhWlSDeMNkQqDIxG
euHPPCW6Q74MZ1gdtVhTlZSnndJCZsWrtzF2vcUoV5Bp2eg2G+/vWxRghshZ
Zp0MV5HDnLscO6QdIZXk/JiM3DbvbpnIASPdlyXkqHB6coYAcyE4g7SJzB9u
Xokt4EhU90HIRUpwi2va9GxCRg06e0MCzAA5v3wEpsqrCYrLowvkGSkjKOka
AWZqvUSB2Epi0uAyJ+1T+As/oBVcFOSjyl2oO9sjunmXo9TbabmYI9VC626k
V+1dQd0dYL9FOWzs5UuaO+0UfpByGNnHbbQx+wbN8c9aGx3b9kP5yO+0DtkH
++4owy330SHr15RDfOMQ9gl6t0YhSgxi4+2J268BgThCe7NBiLnnR0IIgpAB
7Qw0oFH/fXXzsGbeK0AGi0Acrif8KQp0ZWhwptTiXGAge7NRMv651JGZBIo9
lUAsb1FOAkdDudFNwiRQOxolK2zmtXrkM6DAl+UUTKAudoH9ruhJ6bjdVQs9
o6egm5D3YfOBsraqZu1Wej2vAvspAojGaO4B3ey8nMIfF0Lt4hkEOkO+/Vt4
2qPlbNyDuRNrF+36aV0pAiPLTYeUjINkx3sSQcJDvc85YRu0znAl9BQg4vi6
ejIP45mLI5AoX+QCidqgdVwgfwItEugakOMD0FJj9iATSNQGreM26E/RCW4J
050BWhIpxwDaH0+l/VBmz48zApq/Cly1IZbl1juWagWQZ3o8UFJyG0PBxbAj
KUkdCbQucp5gpDBqUo7LHatmtZNO5+XDSZm7hGZTLdRX+cjHQLV+0UPoIns7
rBU+ULeXaGdLO3sNJFd/5obRFXPrensmUn1Wz9Ir+chPQBN5SSGy3Ixp7xNE
Yegj51fj2F8wflURaCJWtAEcZoucu8ewOm56DMuj/AQ8ogsYFvTzdiQfYutV
vnOaAO+SRGwK+on0Gtdwu6/XRGu09wbr9zVxtkQjAq+gvYwRLfF8utjctfen
VCCul9VL5bd8ZBXoFX7JIZY4hMYT/oRAqH0+CCIxF0l0QRCSqz9Lc+nMuY/u
nQTRoUOAK5V/Lif1z6LXFQCcyCNaOWlEE73JAOBEvhkoJ90MiF5y8PYrZOhN
gCbgJyMh+vRvwMlI581D9D6ElpPsQzfoMGMQ5wZS5YyrvpMqaeiLXm/gvw1S
U3L9XZz9d4bpCHa5lK0WMvF3gnRE5ehHoY6e+zzL8aag3JhUe7FGHutGobGO
s0Bm1NUBKO/NXh+0+yl3shT3M522E29KsKVL+3U6bcXEQ0trkLb+11L1J9e5
k6pzgS30xnq6wBbjct6OBjbo5Xz2npy7Kn9kg96sh7jJLMgZyB/k1NfiZDgk
qYsZ24a9+Qrmc6msBH6BLQxrtvICO8BF9uFskMoNpPoXpeqbiBZdp+4JJV2Q
SbadSnc1CnVXXnJiIbPOTpx6naz5FQq8cAsxk9V9pbvT0ORtHYporkIc/22y
pmQKySSxtyx2IulMTyW5raSLcG4okyZshBi916DPmn+ERIW/b3vRZA==\
\>"]]
}, Open  ]]
},
WindowSize->{1438, 1362},
WindowMargins->{{Automatic, 369}, {0, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 833, 22, 31, "Input"],
Cell[1393, 44, 444, 10, 31, "Input"],
Cell[CellGroupData[{
Cell[1862, 58, 144, 2, 31, "Input"],
Cell[2009, 62, 94, 1, 30, "Output"]
}, Open  ]],
Cell[2118, 66, 734, 20, 31, "Input"],
Cell[CellGroupData[{
Cell[2877, 90, 333, 8, 31, "Input"],
Cell[3213, 100, 118, 1, 30, "Output"]
}, Open  ]],
Cell[3346, 104, 1683, 39, 31, "Input"],
Cell[CellGroupData[{
Cell[5054, 147, 1022, 23, 31, "Input"],
Cell[6079, 172, 10700, 196, 368, 4542, 94, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16816, 373, 871, 20, 31, "Input"],
Cell[17690, 395, 3086, 54, 246, "Output"]
}, Open  ]],
Cell[20791, 452, 122, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[20938, 458, 1866, 40, 31, "Input"],
Cell[22807, 500, 953, 24, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23797, 529, 410, 8, 31, "Input"],
Cell[24210, 539, 3748, 80, 237, 1684, 45, "CachedBoxData", "BoxData", "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

